<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('money_requisition_details', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // FK column (NOT NULL)
            $table->foreignId('money_requisition_id')
                  ->constrained('money_requisitions')   // references id on money_requisitions
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();                 // চাইলে ->cascadeOnDelete() দিতে পারেন

            // Columns (exactly as your dump)
            $table->string('description', 191)->nullable();
            $table->decimal('quantity',   16, 6)->default(0);
            $table->decimal('unit',       16, 6)->default(0); // আপনার ডাম্পে unit decimal—সেটাই রাখা হয়েছে
            $table->decimal('rate',       16, 6)->default(0);
            $table->decimal('total_cost', 16, 6)->default(0);

            $table->timestamps(); // created_at, updated_at (nullable)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('money_requisition_details');
    }
};

