<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('money_requisitions', function (Blueprint $table) {
            $table->id(); // BIGINT UNSIGNED AI

            // FKs (match your dump: NOT NULL)
            $table->foreignId('company_id')
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->string('requested_by', 191)->nullable();
            $table->string('project_name', 191)->nullable();
            $table->string('project_code', 191)->nullable();

            $table->date('date');

            $table->decimal('subtotal', 16, 6)->default(0);
            $table->decimal('extra_charge', 16, 6)->default(0);
            $table->decimal('grand_total', 16, 6)->default(0);

            $table->tinyInteger('is_approved')->default(0); // tinyint(4) NOT NULL default 0

            // FKs (NOT NULL)
            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->foreignId('updated_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete();

            $table->timestamps(); // created_at, updated_at (nullable in MySQL)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('money_requisitions');
    }
};

