<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('modules', function (Blueprint $table) {
            $table->id();                    // bigint unsigned auto-increment
            $table->string('name', 191);     // varchar(191) NOT NULL
            $table->tinyInteger('status')    // tinyint (signed), NULL allowed, default 1
                  ->nullable()
                  ->default(1);
            $table->timestamps();            // created_at, updated_at (nullable)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('modules');
    }
};

