<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('jobs', function (Blueprint $table) {
            $table->id();                                   // bigint unsigned AI
            $table->string('queue', 191)->index('jobs_queue_index');
            $table->longText('payload');
            $table->unsignedTinyInteger('attempts');
            $table->unsignedInteger('reserved_at')->nullable();
            $table->unsignedInteger('available_at');
            $table->unsignedInteger('created_at');         // নোট: এখানে timestamps নেই, exact dump মতো int
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('jobs');
    }
};

