<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('item_units')) {
            Schema::create('item_units', function (Blueprint $table) {
                $table->id(); // BIGINT UNSIGNED AI

                // FK columns (FK later add হবে)
                $table->unsignedBigInteger('group_id');
                $table->unsignedBigInteger('created_by');
                $table->unsignedBigInteger('updated_by');

                // Columns (আপনার ডাম্প অনুযায়ী)
                $table->string('name', 191)->index();
                $table->string('conversion', 191)->nullable();
                $table->tinyInteger('status')->default(1);
                $table->timestamps();

                // helpful indexes (safe)
                $table->index('group_id', 'item_units_group_id_index');
                $table->index('created_by', 'item_units_created_by_index');
                $table->index('updated_by', 'item_units_updated_by_index');

                // Unique: (group_id, name)
                $table->unique(['group_id', 'name'], 'item_units_group_id_name_unique');
            });
        }
    }

    public function down(): void
    {
        Schema::dropIfExists('item_units');
    }
};
