<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('issue_raw_material_details')) {
            Schema::create('issue_raw_material_details', function (Blueprint $t) {
                $t->id();

                // BIGINT UNSIGNED columns (match your dump)
                $t->unsignedBigInteger('issue_raw_material_id');     // FK later
                $t->unsignedBigInteger('material_id')->comment('product_id'); // FK later
                $t->unsignedBigInteger('bag_type_id')->nullable();   // FK later
                $t->decimal('kg', 20, 2)->default(0.00);
                $t->decimal('mon', 20, 2)->default(0.00);
                $t->decimal('bag', 20, 2)->default(0.00);
                $t->decimal('price', 20, 2)->default(0.00);
                $t->decimal('total_amount', 20, 2)->default(0.00);
                $t->string('remarks', 191)->nullable();
                $t->timestamps();
                $t->unsignedBigInteger('warehouse_id')->nullable();  // FK later

                // Helpful indexes (harmless if duplicates)
                $t->index('issue_raw_material_id', 'irmd_issue_raw_material_id_index');
                $t->index('bag_type_id', 'irmd_bag_type_id_index');
                $t->index('material_id', 'irmd_material_id_index');
                $t->index('warehouse_id', 'irmd_warehouse_id_index');
            });
        }
    }

    public function down(): void
    {
        // Drop the table (Laravel will drop indexes automatically)
        Schema::dropIfExists('issue_raw_material_details');
    }
};




