<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('rm_warehouse_types', function (Blueprint $table) {
            $table->id(); // bigint unsigned auto-increment
            $table->string('name', 191);
            $table->string('status', 191)->default('1'); // matches varchar(191) with default 1
            $table->unsignedBigInteger('created_by')->nullable()->index();
            $table->unsignedBigInteger('updated_by')->nullable()->index();
            $table->timestamps();

            // FKs to users table
            $table->foreign('created_by', 'rm_warehouse_types_created_by_foreign')
                  ->references('id')->on('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            $table->foreign('updated_by', 'rm_warehouse_types_updated_by_foreign')
                  ->references('id')->on('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();
        });
    }

    public function down(): void
    {
        Schema::table('rm_warehouse_types', function (Blueprint $table) {
            // drop FKs first (names match above)
            $table->dropForeign('rm_warehouse_types_created_by_foreign');
            $table->dropForeign('rm_warehouse_types_updated_by_foreign');
        });

        Schema::dropIfExists('rm_warehouse_types');
    }
};
