<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (Schema::hasTable('issue_raw_materials') && Schema::hasTable('companies')) {
            Schema::table('issue_raw_materials', function (Blueprint $table) {
                $table->foreign('company_id', 'irm_company_fk')
                    ->references('id')->on('companies')
                    ->onUpdate('cascade')->nullOnDelete();
            });
        }

        if (Schema::hasTable('issue_raw_materials') && Schema::hasTable('users')) {
            Schema::table('issue_raw_materials', function (Blueprint $table) {
                $table->foreign('created_by', 'irm_created_by_fk')
                    ->references('id')->on('users')
                    ->onUpdate('cascade')->onDelete('restrict');

                $table->foreign('updated_by', 'irm_updated_by_fk')
                    ->references('id')->on('users')
                    ->onUpdate('cascade')->nullOnDelete();
            });
        }

        if (Schema::hasTable('issue_raw_materials') && Schema::hasTable('warehouses')) {
            Schema::table('issue_raw_materials', function (Blueprint $table) {
                $table->foreign('warehouse_id', 'irm_warehouse_fk')
                    ->references('id')->on('warehouses')
                    ->onUpdate('cascade')->nullOnDelete();

                $table->foreign('empty_bag_warehouse', 'irm_empty_bag_wh_fk')
                    ->references('id')->on('warehouses')
                    ->onUpdate('cascade')->nullOnDelete();
            });
        }

        if (Schema::hasTable('issue_raw_materials') && Schema::hasTable('dayars')) {
            Schema::table('issue_raw_materials', function (Blueprint $table) {
                $table->foreign('dayar_id', 'irm_dayar_fk')
                    ->references('id')->on('dayars')
                    ->onUpdate('cascade')->nullOnDelete();
            });
        }

        if (Schema::hasTable('issue_raw_materials') && Schema::hasTable('employees')) {
            Schema::table('issue_raw_materials', function (Blueprint $table) {
                $table->foreign('employee_id', 'irm_employee_fk')
                    ->references('id')->on('employees')
                    ->onUpdate('cascade')->nullOnDelete();
            });
        }
    }

    public function down(): void
    {
        if (Schema::hasTable('issue_raw_materials')) {
            Schema::table('issue_raw_materials', function (Blueprint $table) {
                foreach ([
                    'irm_company_fk',
                    'irm_created_by_fk',
                    'irm_updated_by_fk',
                    'irm_warehouse_fk',
                    'irm_empty_bag_wh_fk',
                    'irm_dayar_fk',
                    'irm_employee_fk',
                ] as $fk) {
                    try { $table->dropForeign($fk); } catch (\Throwable $e) {}
                }
            });
        }
    }
};

