<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('issue_raw_materials', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            // FK columns as plain unsigned bigints (FKs will be added later)
            $table->unsignedBigInteger('company_id')->nullable()->index();
            $table->unsignedBigInteger('created_by')->index();
            $table->unsignedBigInteger('updated_by')->nullable()->index();
            $table->unsignedBigInteger('warehouse_id')->nullable()->index();
            $table->unsignedBigInteger('dayar_id')->nullable()->index();
            $table->unsignedBigInteger('employee_id')->nullable()->index();
            $table->unsignedBigInteger('empty_bag_warehouse')->nullable()->index();

            $table->string('invoice_no', 191)->nullable();
            $table->date('date');

            $table->longText('expected_costs')->nullable()->collation('utf8mb4_bin');
            $table->longText('expected_cost_reasons')->nullable()->collation('utf8mb4_bin');
            $table->decimal('expected_cost', 8, 2)->nullable();

            $table->string('boil_time_start', 191)->nullable();
            $table->string('steam_time', 191)->nullable();
            $table->string('boil_time_end', 191)->nullable();

            $table->tinyInteger('is_approved')->default(0);

            $table->string('lof_no', 191)->nullable();
            $table->string('reference', 191)->nullable();
            $table->string('remarks', 191)->nullable();

            $table->tinyInteger('is_production')->default(0);
            $table->text('attachment')->nullable();

            // dump অনুযায়ী timestamps nullable
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('issue_raw_materials');
    }
};
