<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('invoice_nos', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            // PK
            $table->bigIncrements('id');

            // Columns (per your structure)
            $table->string('type', 191);           // NOT NULL
            $table->string('year', 191);           // NOT NULL
            $table->unsignedInteger('next_id')->default(1); // int(10) UNSIGNED DEFAULT 1

            // Nullable company FK
            $table->foreignId('company_id')
                  ->nullable()
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();

            // Timestamps (nullable as in your dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Indexes (FK already indexed, adding explicit is fine too)
            $table->index('company_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('invoice_nos');
    }
};
