<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('id_card_settings', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            // PK
            $table->bigIncrements('id');

            // Columns (ordered to mirror your dump)
            $table->string('logo', 191)->nullable();

            // FKs
            $table->foreignId('company_id')
                  ->constrained('companies')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // NOT NULL → can't nullify on delete

            $table->foreignId('created_by')
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->restrictOnDelete(); // NOT NULL

            $table->foreignId('updated_by')
                  ->nullable()
                  ->constrained('users')
                  ->cascadeOnUpdate()
                  ->nullOnDelete();     // NULLable → set NULL if user deleted

            // Other fields
            $table->longText('address')->nullable();
            $table->string('web_url', 191)->nullable();
            $table->string('mobile', 191)->nullable();
            $table->string('email', 191)->nullable();
            $table->string('signature', 191)->nullable();
            $table->string('issue_date', 191)->nullable();

            // Timestamps (nullable per your structure)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Remaining fields
            $table->string('corporate_address', 191)->nullable();
            $table->string('group_logo', 191)->nullable();

            // Helpful indexes (optional; foreignId already adds indexes)
            $table->index('company_id');
            $table->index('created_by');
            $table->index('updated_by');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('id_card_settings');
    }
};

