<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('groups', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->string('name', 191);
            $table->string('email', 100)->nullable()->unique();   // groups_email_unique
            $table->string('phone', 20)->nullable()->unique();    // groups_phone_unique
            $table->string('address', 191)->nullable();
            $table->string('logo', 191)->nullable();
            $table->string('fav_icon', 191)->nullable();
            $table->string('login_background_image', 191)->nullable();

            // nullable timestamps (matches your dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('groups');
    }
};

