<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('goods_requisition_details')) return;

        Schema::table('goods_requisition_details', function (Blueprint $table) {
            // goods_requisition_id -> goods_requisitions(id)
            if (Schema::hasTable('goods_requisitions')) {
                $table->foreign('goods_requisition_id', 'grd_goods_requisition_fk')
                      ->references('id')->on('goods_requisitions')
                      ->onUpdate('cascade')->onDelete('cascade'); // delete details with parent
            }

            // company_id -> companies(id)
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'grd_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')->onDelete('restrict');
            }

            // updated_by -> users(id)
            if (Schema::hasTable('users')) {
                $table->foreign('updated_by', 'grd_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')->onDelete('restrict');
            }

            // item_id -> items(id)  (change table name if your catalog table differs)
            if (Schema::hasTable('items')) {
                $table->foreign('item_id', 'grd_item_fk')
                      ->references('id')->on('items')
                      ->onUpdate('cascade')->onDelete('restrict');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('goods_requisition_details')) return;

        Schema::table('goods_requisition_details', function (Blueprint $table) {
            foreach (['grd_goods_requisition_fk', 'grd_company_fk', 'grd_updated_by_fk', 'grd_item_fk'] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};

