<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('goods_requisition_details', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->float('quantity')->default(0);           // float NOT NULL DEFAULT 0
            $table->string('remarks', 191)->nullable();

            // FK-ish columns (NOT NULL in dump)
            $table->unsignedBigInteger('goods_requisition_id');
            $table->unsignedBigInteger('company_id');
            $table->unsignedBigInteger('created_by');        // NOT indexed in your dump
            $table->unsignedBigInteger('updated_by');
            $table->unsignedBigInteger('item_id');

            $table->double('price')->nullable();

            // timestamps nullable (as in dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            $table->string('inactive', 191)->nullable();
            $table->string('suspend', 191)->nullable();

            // Plain BTREE indexes with the *exact names* shown in your dump
            $table->index('item_id', 'goods_requisition_details_item_id_foreign');
            $table->index('company_id', 'goods_requisition_details_company_id_foreign');
            $table->index('updated_by', 'goods_requisition_details_updated_by_foreign');
            $table->index('goods_requisition_id', 'goods_requisition_details_goods_requisition_id_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('goods_requisition_details');
    }
};

