<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('goods_requisitions')) return;

        Schema::table('goods_requisitions', function (Blueprint $table) {
            // Minimal FKs exactly for the three indexed columns in your dump:
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'gr_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')->onDelete('restrict');
            }

            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'gr_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')->onDelete('restrict');

                // updated_by is NOT NULL in your dump, so use RESTRICT (not set null)
                $table->foreign('updated_by', 'gr_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')->onDelete('restrict');
            }

            // Optional extra FKs (uncomment if you have these parent tables and want the links):
            if (Schema::hasTable('employees')) {
                $table->foreign('employee_id', 'gr_employee_fk')
                      ->references('id')->on('employees')
                      ->onUpdate('cascade')->onDelete('set null');
            }
            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'gr_warehouse_fk')
                      ->references('id')->on('warehouses')
                      ->onUpdate('cascade')->onDelete('set null');
            }
            if (Schema::hasTable('departments')) {
                $table->foreign('department_id', 'gr_department_fk')
                      ->references('id')->on('departments')
                      ->onUpdate('cascade')->onDelete('restrict');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('goods_requisitions')) return;

        Schema::table('goods_requisitions', function (Blueprint $table) {
            foreach ([
                'gr_company_fk', 'gr_created_by_fk', 'gr_updated_by_fk',
                'gr_employee_fk', 'gr_warehouse_fk', 'gr_department_fk',
            ] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};
