<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('goods_requisitions', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->string('invoice_no', 191)->nullable();
            $table->unsignedBigInteger('employee_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();

            $table->date('goods_requisition_date');                // NOT NULL
            $table->string('goods_requisition_reference', 191)->nullable();

            $table->integer('total_quantity')->default(0);         // int(11) DEFAULT 0
            $table->string('form_number', 191)->nullable();

            $table->timestamp('issue_date')->nullable();
            $table->string('issue_number', 191)->nullable();

            $table->tinyInteger('is_approved')->default(0);

            $table->unsignedBigInteger('company_id');              // NOT NULL (indexed in dump)
            $table->unsignedBigInteger('department_id');           // NOT NULL
            $table->unsignedBigInteger('created_by');              // NOT NULL (indexed in dump)
            $table->unsignedBigInteger('updated_by');              // NOT NULL (indexed in dump)

            // timestamps nullable (to mirror dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // longtext with binary collation as shown
            $table->longText('expected_costs')->nullable()->collation('utf8mb4_bin');
            $table->longText('expected_cost_reasons')->nullable()->collation('utf8mb4_bin');

            // Plain BTREE indexes (names exactly like your screenshot)
            $table->index('company_id', 'goods_requisitions_company_id_foreign');
            $table->index('created_by', 'goods_requisitions_created_by_foreign');
            $table->index('updated_by', 'goods_requisitions_updated_by_foreign');

            // Optional helpful indexes (not in dump, safe to skip if you want a 1:1 mirror):
            // $table->index('employee_id');
            // $table->index('warehouse_id');
            // $table->index('department_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('goods_requisitions');
    }
};
