<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('fund_transfers', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->string('invoice_no', 191)->nullable();

            $table->unsignedBigInteger('from_account_id'); // Index in dump
            $table->unsignedBigInteger('to_account_id');   // Index in dump

            $table->string('description', 191)->nullable();
            $table->decimal('amount', 15, 2);              // NOT NULL
            $table->date('date');                           // NOT NULL
            $table->string('reference', 191)->nullable();

            $table->tinyInteger('is_approved')->default(0); // default 0

            $table->unsignedBigInteger('company_id');       // Index in dump
            $table->unsignedBigInteger('created_by');       // Index in dump
            $table->unsignedBigInteger('updated_by')->nullable(); // Index in dump

            // timestamps nullable (to mirror dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Plain BTREE indexes with the exact names from your screenshot
            $table->index('from_account_id', 'fund_transfers_from_account_id_foreign');
            $table->index('to_account_id',   'fund_transfers_to_account_id_foreign');
            $table->index('company_id',      'fund_transfers_company_id_foreign');
            $table->index('created_by',      'fund_transfers_created_by_foreign');
            $table->index('updated_by',      'fund_transfers_updated_by_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('fund_transfers');
    }
};

