<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('finish_production_details')) return;

        Schema::table('finish_production_details', function (Blueprint $table) {
            // finish_production
            if (Schema::hasTable('finish_productions')) {
                $table->foreign('finish_production_id', 'fpd_finish_production_fk')
                      ->references('id')->on('finish_productions')
                      ->onUpdate('cascade')->onDelete('cascade'); // delete details with header
            }

            // Product (use the correct table for your app: finish_products or products)
            if (Schema::hasTable('finish_products')) {
                $table->foreign('product_id', 'fpd_finish_product_fk')
                      ->references('id')->on('finish_products')
                      ->onUpdate('cascade')->onDelete('restrict');
            } elseif (Schema::hasTable('products')) {
                $table->foreign('product_id', 'fpd_product_fk')
                      ->references('id')->on('products')
                      ->onUpdate('cascade')->onDelete('restrict');
            }

            // Warehouses
            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'fpd_warehouse_fk')
                      ->references('id')->on('warehouses')
                      ->onUpdate('cascade')->onDelete('set null');

                $table->foreign('bag_warehouse_id', 'fpd_bag_warehouse_fk')
                      ->references('id')->on('warehouses')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            // Bags (use finish_bags if that’s what bag_id points to)
            if (Schema::hasTable('finish_bags')) {
                $table->foreign('bag_id', 'fpd_bag_fk')
                      ->references('id')->on('finish_bags')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            // Bag types
            if (Schema::hasTable('bag_types')) {
                $table->foreign('bag_type_id', 'fpd_bag_type_fk')
                      ->references('id')->on('bag_types')
                      ->onUpdate('cascade')->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('finish_production_details')) return;

        Schema::table('finish_production_details', function (Blueprint $table) {
            foreach ([
                'fpd_finish_production_fk',
                'fpd_finish_product_fk', 'fpd_product_fk',
                'fpd_warehouse_fk', 'fpd_bag_warehouse_fk',
                'fpd_bag_fk', 'fpd_bag_type_fk',
            ] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};
