<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('finish_production_details', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->unsignedBigInteger('finish_production_id'); // indexed below (name copied from dump)
            $table->unsignedBigInteger('product_id');           // required
            $table->unsignedBigInteger('bag_warehouse_id')->nullable();
            $table->unsignedBigInteger('bag_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();
            $table->unsignedBigInteger('bag_type_id')->nullable();

            $table->decimal('kg',          20, 2)->default(0);
            $table->decimal('bag',         20, 2)->default(0);
            $table->decimal('price',       20, 2)->default(0);
            $table->decimal('total_amount',20, 2)->default(0);

            $table->string('remarks', 191)->nullable();

            // Timestamps (nullable to match your dump)
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Plain BTREE index with the exact name from your dump
            $table->index('finish_production_id', 'finish_production_details_finish_production_id_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('finish_production_details');
    }
};

