<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('finish_productions')) return;

        Schema::table('finish_productions', function (Blueprint $table) {
            // company
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'fp_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            // created_by / updated_by
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'fp_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')->onDelete('restrict');

                $table->foreign('updated_by', 'fp_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            // warehouse
            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'fp_warehouse_fk')
                      ->references('id')->on('warehouses')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            // mill
            if (Schema::hasTable('mills')) {
                $table->foreign('mill_id', 'fp_mill_fk')
                      ->references('id')->on('mills')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            // issue (adjust parent table if needed, e.g. 'issue_rms' / 'issues')
            if (Schema::hasTable('issue_rms')) {
                $table->foreign('issue_id', 'fp_issue_fk')
                      ->references('id')->on('issue_rms')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            // production (adjust parent table if needed, e.g. 'productions')
            if (Schema::hasTable('productions')) {
                $table->foreign('production_id', 'fp_production_fk')
                      ->references('id')->on('productions')
                      ->onUpdate('cascade')->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('finish_productions')) return;

        Schema::table('finish_productions', function (Blueprint $table) {
            foreach ([
                'fp_company_fk','fp_created_by_fk','fp_updated_by_fk',
                'fp_warehouse_fk','fp_mill_fk','fp_issue_fk','fp_production_fk'
            ] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};

