<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('finish_productions', function (Blueprint $table) {
            // keep engine/collation consistent with your dump
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->unsignedBigInteger('issue_id')->nullable();
            $table->unsignedBigInteger('production_id')->nullable();

            $table->unsignedBigInteger('company_id')->nullable();   // Index in dump
            $table->string('invoice_no', 191)->nullable();

            $table->date('date');                                   // NOT NULL in dump
            $table->tinyInteger('is_approved')->default(0);         // default 0

            $table->unsignedBigInteger('created_by');               // Index in dump, NOT NULL
            $table->unsignedBigInteger('updated_by')->nullable();   // Index in dump, NULL

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            $table->unsignedBigInteger('warehouse_id')->nullable();
            $table->string('silo_no', 191)->nullable();
            $table->string('rice_temparature', 191)->nullable();
            $table->string('remarks', 191)->nullable();

            $table->string('production_time_start', 191)->nullable();
            $table->string('production_time_end', 191)->nullable();
            $table->string('drafer_time_start', 191)->nullable();
            $table->string('drafer_time_end', 191)->nullable();

            $table->unsignedBigInteger('mill_id')->nullable();

            // Plain BTREE indexes with the exact names from your dump
            $table->index('company_id', 'finish_productions_company_id_foreign');
            $table->index('created_by', 'finish_productions_created_by_foreign');
            $table->index('updated_by', 'finish_productions_updated_by_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('finish_productions');
    }
};
