<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('finish_bag_stock_ledgers')) return;

        Schema::table('finish_bag_stock_ledgers', function (Blueprint $table) {
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'fbsl_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'fbsl_warehouse_fk')
                      ->references('id')->on('warehouses')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            // If the product here is a FINISH BAG item, use finish_bags.
            // If it's a general product, swap to 'products'.
            if (Schema::hasTable('finish_bags')) {
                $table->foreign('product_id', 'fbsl_finish_bag_fk')
                      ->references('id')->on('finish_bags')
                      ->onUpdate('cascade')->onDelete('set null');
            }
            // else if (Schema::hasTable('products')) {
            //     $table->foreign('product_id', 'fbsl_product_fk')
            //           ->references('id')->on('products')
            //           ->onUpdate('cascade')->onDelete('set null');
            // }

            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'fbsl_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')->onDelete('set null');

                $table->foreign('updated_by', 'fbsl_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('finish_bag_stock_ledgers')) return;

        Schema::table('finish_bag_stock_ledgers', function (Blueprint $table) {
            foreach ([
                'fbsl_company_fk','fbsl_warehouse_fk',
                'fbsl_finish_bag_fk','fbsl_product_fk',
                'fbsl_created_by_fk','fbsl_updated_by_fk'
            ] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};
