<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('finish_bag_stock_ledgers', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->unsignedBigInteger('company_id')->nullable();   // Index in dump
            $table->unsignedBigInteger('product_id')->nullable();   // Index in dump
            $table->unsignedBigInteger('warehouse_id')->nullable();

            $table->string('sourceable_type', 191)->nullable();
            $table->unsignedBigInteger('sourceable_id')->nullable();

            $table->date('date')->nullable();

            $table->decimal('quantity',         10, 2)->nullable();
            $table->decimal('in',               10, 2)->nullable(); // column name is 'in' per dump
            $table->decimal('out',              10, 2)->nullable();
            $table->decimal('current_quantity', 10, 2)->nullable();

            $table->string('remarks', 191)->nullable();

            $table->unsignedBigInteger('created_by')->nullable();   // Index in dump
            $table->unsignedBigInteger('updated_by')->nullable();   // Index in dump

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Plain BTREE indexes with exact names from the dump
            $table->index('product_id', 'finish_bag_stock_ledgers_product_id_foreign');
            $table->index('company_id', 'finish_bag_stock_ledgers_company_id_foreign');
            $table->index('created_by', 'finish_bag_stock_ledgers_created_by_foreign');
            $table->index('updated_by', 'finish_bag_stock_ledgers_updated_by_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('finish_bag_stock_ledgers');
    }
};

