<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('finish_bag_stocks')) return;

        Schema::table('finish_bag_stocks', function (Blueprint $table) {
            // Helpful supporting indexes if parents exist (kept minimal)
            if (!Schema::hasColumn('finish_bag_stocks', 'warehouse_id')) return;
            if (!Schema::hasColumn('finish_bag_stocks', 'product_id')) return;

            // Add FKs with custom names so they don't clash with the plain index names
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'fbs_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            if (Schema::hasTable('warehouses')) {
                // index not shown in dump; FK will create one if needed
                $table->foreign('warehouse_id', 'fbs_warehouse_fk')
                      ->references('id')->on('warehouses')
                      ->onUpdate('cascade')->onDelete('set null');
            }

            // If your product here means a FINISH BAG item, link to finish_bags.
            // If it's a generic product, swap to 'products'.
            if (Schema::hasTable('finish_bags')) {
                $table->foreign('product_id', 'fbs_finish_bag_fk')
                      ->references('id')->on('finish_bags')
                      ->onUpdate('cascade')->onDelete('set null');
            }
            // else if (Schema::hasTable('products')) {
            //     $table->foreign('product_id', 'fbs_product_fk')
            //           ->references('id')->on('products')
            //           ->onUpdate('cascade')->onDelete('set null');
            // }

            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'fbs_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')->onDelete('set null');

                $table->foreign('updated_by', 'fbs_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('finish_bag_stocks')) return;

        Schema::table('finish_bag_stocks', function (Blueprint $table) {
            foreach ([
                'fbs_company_fk','fbs_warehouse_fk',
                'fbs_finish_bag_fk','fbs_product_fk',
                'fbs_created_by_fk','fbs_updated_by_fk'
            ] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};

