<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('finish_bag_stocks', function (Blueprint $table) {
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->unsignedBigInteger('company_id')->nullable();   // Index in dump
            $table->unsignedBigInteger('warehouse_id')->nullable();
            $table->unsignedBigInteger('product_id')->nullable();

            $table->decimal('opening_quantity',        20, 2)->default(0.00);
            $table->decimal('purchased_quantity',      20, 2)->default(0.00);
            $table->decimal('purchase_return_quantity',20, 2)->default(0.00);
            $table->decimal('sold_quantity',           20, 2)->default(0.00);
            $table->decimal('return_quantity',         20, 2)->default(0.00);
            $table->decimal('damaged_quantity',        20,  2)->default(0.00);
            $table->decimal('production_quantity',     20, 2)->default(0.00);
            $table->decimal('issue_quantity',          20, 2)->default(0.00);
            $table->decimal('adjustment_in',           20, 2)->default(0.00);
            $table->decimal('adjustment_out',          20, 2)->default(0.00);
            $table->decimal('transfer_in',             20, 2)->default(0.00);
            $table->decimal('transfer_out',            20, 2)->default(0.00);
            $table->decimal('available_quantity',      20, 2)->default(0.00);

            $table->unsignedBigInteger('created_by')->nullable();   // Index in dump
            $table->unsignedBigInteger('updated_by')->nullable();   // Index in dump

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Plain indexes with the exact names shown in your dump
            $table->index('company_id', 'finish_bag_stocks_company_id_foreign');
            $table->index('created_by', 'finish_bag_stocks_created_by_foreign');
            $table->index('updated_by', 'finish_bag_stocks_updated_by_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('finish_bag_stocks');
    }
};
