<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('finish_bag_adjustment_details', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            // Per dump
            $table->unsignedBigInteger('finish_bag_adjustment_id'); // NOT NULL
            $table->unsignedBigInteger('product_id')->nullable();
            $table->unsignedBigInteger('warehouse_id')->nullable();

            $table->decimal('quantity', 8, 2)->nullable()->default(0.00);
            $table->string('adjustment_type', 191)->nullable();
            $table->string('remarks', 191)->nullable();

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Dump shows only PRIMARY, so no extra indexes here.
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('finish_bag_adjustment_details');
    }
};
