<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('finish_bag_adjustments')) return;

        Schema::table('finish_bag_adjustments', function (Blueprint $table) {
            // warehouse_id → warehouses.id
            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'fba_warehouse_fk')
                      ->references('id')->on('warehouses')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            // created_by / updated_by → users.id
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'fba_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');

                $table->foreign('updated_by', 'fba_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('finish_bag_adjustments')) return;

        Schema::table('finish_bag_adjustments', function (Blueprint $table) {
            foreach (['fba_warehouse_fk','fba_created_by_fk','fba_updated_by_fk'] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};
