<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('finish_bag_adjustments', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->unsignedBigInteger('warehouse_id')->nullable();
            $table->string('invoice_no', 191)->nullable();
            $table->date('date')->nullable();
            $table->decimal('total_quantity', 8, 2)->nullable();
            $table->string('remarks', 191)->nullable();

            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps(); // created_at, updated_at (nullable in MySQL)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('finish_bag_adjustments');
    }
};

