<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('finish_bags')) return;

        Schema::table('finish_bags', function (Blueprint $table) {

            if (Schema::hasTable('warehouses')) {
                $table->foreign('warehouse_id', 'fb_warehouse_fk')
                      ->references('id')->on('warehouses')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            if (Schema::hasTable('suppliers')) {
                $table->foreign('supplier_id', 'fb_supplier_fk')
                      ->references('id')->on('suppliers')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            if (Schema::hasTable('units')) {
                $table->foreign('unit_id', 'fb_unit_fk')
                      ->references('id')->on('units')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            if (Schema::hasTable('categories')) {
                $table->foreign('category_id', 'fb_category_fk')
                      ->references('id')->on('categories')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'fb_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');

                $table->foreign('updated_by', 'fb_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('finish_bags')) return;

        Schema::table('finish_bags', function (Blueprint $table) {
            foreach ([
                'fb_warehouse_fk','fb_supplier_fk','fb_unit_fk','fb_category_fk',
                'fb_created_by_fk','fb_updated_by_fk'
            ] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};
