<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('finish_bags', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->bigIncrements('id');

            $table->string('name', 191)->nullable();

            $table->unsignedBigInteger('warehouse_id')->nullable();
            $table->unsignedBigInteger('supplier_id')->nullable();
            $table->unsignedBigInteger('unit_id')->nullable();
            $table->unsignedBigInteger('category_id')->nullable();

            $table->decimal('opening_quantity', 16, 2)->nullable()->default(0.00);
            $table->decimal('alert_quantity',   16, 2)->nullable()->default(0.00);
            $table->decimal('price',            16, 2)->nullable()->default(0.00);

            $table->string('status', 191)->default('1'); // NOT NULL default '1' (string)

            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();

            // Your dump shows only PRIMARY, so we intentionally don't add extra indexes here.
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('finish_bags');
    }
};
