<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('failed_jobs', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            // Columns per your dump
            $table->bigIncrements('id');        // BIGINT UNSIGNED AI (PRIMARY)
            $table->text('connection');         // NOT NULL
            $table->text('queue');              // NOT NULL
            $table->longText('payload');        // NOT NULL
            $table->longText('exception');      // NOT NULL
            $table->timestamp('failed_at')->useCurrent(); // NOT NULL DEFAULT CURRENT_TIMESTAMP

            // No extra indexes (dump shows only PRIMARY)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('failed_jobs');
    }
};

