<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('department_user', function (Blueprint $table) {
            // Consistency
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            // NOT NULL per dump
            $table->unsignedBigInteger('department_id');
            $table->unsignedBigInteger('user_id');

            $table->timestamps(); // created_at, updated_at (nullable)

            // Plain index name exactly as in your dump
            $table->index('user_id', 'department_user_user_id_foreign');

            // (Optional) prevent duplicates:
            // $table->unique(['department_id','user_id'], 'department_user_unique_pair');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('department_user');
    }
};
