<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('dayars')) return;

        Schema::table('dayars', function (Blueprint $table) {
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'dayars_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');

                $table->foreign('updated_by', 'dayars_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('dayars')) return;

        Schema::table('dayars', function (Blueprint $table) {
            foreach (['dayars_created_by_fk','dayars_updated_by_fk'] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};

