<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('dayars', function (Blueprint $table) {
            // Consistency with your schema
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            $table->string('name', 191);         // NOT NULL
            $table->string('status', 191)->default('1'); // NOT NULL default '1' (string)

            // Audit (both nullable per dump)
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps(); // created_at, updated_at (nullable)

            // Plain index names exactly like the dump
            $table->index('created_by', 'dayars_created_by_foreign');
            $table->index('updated_by', 'dayars_updated_by_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('dayars');
    }
};

