<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('customer_uploads')) return;

        Schema::table('customer_uploads', function (Blueprint $table) {
            if (Schema::hasTable('users')) {
                // created_by: required → RESTRICT delete, CASCADE update
                $table->foreign('created_by', 'cu_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');

                // updated_by: nullable → SET NULL on delete, CASCADE update
                $table->foreign('updated_by', 'cu_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('customer_uploads')) return;

        Schema::table('customer_uploads', function (Blueprint $table) {
            foreach (['cu_created_by_fk','cu_updated_by_fk'] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};

