<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('customer_uploads', function (Blueprint $table) {
            // Consistency
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            $table->string('name', 191);
            $table->string('company_name', 191)->nullable();
            $table->string('personal_phone', 191)->nullable();
            $table->string('email', 191)->nullable();
            $table->string('address', 191)->nullable();
            $table->string('party_type', 191)->nullable();
            $table->string('area', 191)->nullable();
            $table->tinyInteger('customer_type')->nullable();
            $table->string('executive_name', 191)->nullable();
            $table->decimal('opening_balance', 10, 2)->nullable();
            $table->decimal('due_limit', 10, 2)->nullable();
            $table->string('remarks', 191)->nullable();
            $table->tinyInteger('status')->nullable()->default(1);

            // Audit (per dump)
            $table->unsignedBigInteger('created_by');       // NOT NULL
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();

            // Plain index names exactly as in your dump
            $table->index('created_by', 'customer_uploads_created_by_foreign');
            $table->index('updated_by', 'customer_uploads_updated_by_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('customer_uploads');
    }
};

