<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('customer_ledgers', function (Blueprint $table) {
            // Keep things consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            // As per dump
            $table->unsignedBigInteger('customer_id'); // NOT NULL
            $table->unsignedBigInteger('sale_id');     // NOT NULL

            $table->string('invoice_no', 191)->nullable();
            $table->string('date', 191);               // NOT NULL (dump uses varchar)

            $table->enum('balance_type', ['Debit','Credit']); // NOT NULL

            $table->unsignedBigInteger('account_id')->nullable(); // NULL
            $table->decimal('amount', 15, 2);                     // NOT NULL (no default)

            // Audit
            $table->unsignedBigInteger('created_by');       // NOT NULL
            $table->unsignedBigInteger('updated_by')->nullable(); // NULL

            $table->timestamps(); // created_at, updated_at (nullable)

            // Plain index names exactly like the dump
            $table->index('customer_id', 'customer_ledgers_customer_id_foreign');
            $table->index('sale_id',     'customer_ledgers_sale_id_foreign');
            $table->index('account_id',  'customer_ledgers_account_id_foreign');
            $table->index('created_by',  'customer_ledgers_created_by_foreign');
            $table->index('updated_by',  'customer_ledgers_updated_by_foreign');

            // (Optional) extras for performance:
            // $table->index('date', 'customer_ledgers_date_idx');
            // $table->index(['customer_id','date'], 'customer_ledgers_customer_date_idx');
            // $table->unique(['customer_id','sale_id','balance_type'], 'customer_ledgers_unique_row');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('customer_ledgers');
    }
};

