<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('currency_conversions')) return;

        Schema::table('currency_conversions', function (Blueprint $table) {
            // currencies (required → RESTRICT delete, CASCADE update)
            if (Schema::hasTable('currencies')) {
                $table->foreign('currency_id', 'cc_currency_fk')
                      ->references('id')->on('currencies')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');
            }

            // users (created_by required → RESTRICT; updated_by nullable → SET NULL)
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'cc_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');

                $table->foreign('updated_by', 'cc_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('currency_conversions')) return;

        Schema::table('currency_conversions', function (Blueprint $table) {
            foreach (['cc_currency_fk','cc_created_by_fk','cc_updated_by_fk'] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};
