<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('currency_conversions', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            $table->string('effected_month', 191);     // NOT NULL (mirrors dump)
            $table->unsignedBigInteger('currency_id'); // NOT NULL
            $table->decimal('rate', 14, 2);            // NOT NULL

            // audit
            $table->unsignedBigInteger('created_by');       // NOT NULL
            $table->unsignedBigInteger('updated_by')->nullable(); // NULL

            $table->timestamps(); // created_at, updated_at (nullable)

            // Index names matching your dump (these are plain indexes)
            $table->index('currency_id', 'currency_conversions_currency_id_foreign');
            $table->index('created_by', 'currency_conversions_created_by_foreign');
            $table->index('updated_by', 'currency_conversions_updated_by_foreign');

            // (Optional) prevent duplicates per month & currency:
            // $table->unique(['currency_id','effected_month'], 'cc_unique_currency_month');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('currency_conversions');
    }
};

