<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('countries', function (Blueprint $table) {
            // Keep engine/collation consistent
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id();                 // BIGINT UNSIGNED AI (PRIMARY)
            $table->string('name', 191);  // NOT NULL
            $table->timestamps();         // created_at, updated_at (nullable)
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('countries');
    }
};

