<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('company_details')) return;

        Schema::table('company_details', function (Blueprint $table) {
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'cd_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')
                      ->onDelete('restrict'); // company_id is NOT NULL in dump
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('company_details')) return;

        Schema::table('company_details', function (Blueprint $table) {
            try { $table->dropForeign('cd_company_fk'); } catch (\Throwable $e) {}
        });
    }
};
