<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('company_details', function (Blueprint $table) {
            // Consistency
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            // NOT NULL per dump
            $table->unsignedBigInteger('company_id');

            // Fields (all nullable per dump)
            $table->string('vat_no', 191)->nullable();
            $table->string('facsimile_number', 191)->nullable();
            $table->string('bonded_license', 191)->nullable();
            $table->string('membership_number', 191)->nullable();
            $table->string('bkmea_reg_no', 191)->nullable();
            $table->string('import_reg_certi', 191)->nullable();
            $table->string('export_reg_certi', 191)->nullable();
            $table->string('epb_reg_no', 191)->nullable();

            $table->string('header', 191)->nullable();
            $table->string('footer', 191)->nullable();
            $table->string('organogram', 191)->nullable();
            $table->text('watermark')->nullable();

            $table->timestamps(); // created_at, updated_at (nullable)

            // Index name exactly as in your dump
            $table->index('company_id', 'company_details_company_id_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('company_details');
    }
};
