<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('company_bank_accounts', function (Blueprint $table) {
            // Consistent engine/collation
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            // NOT NULL per dump
            $table->unsignedBigInteger('company_id');

            $table->string('account_name',   191)->nullable();
            $table->string('account_number', 191)->nullable();
            $table->string('bank_name',      191)->nullable();
            $table->string('branch',         191)->nullable();
            $table->string('swift_code',     191)->nullable();

            $table->timestamps(); // created_at, updated_at (nullable by default)

            // Index name exactly as in your dump
            $table->index('company_id', 'company_bank_accounts_company_id_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('company_bank_accounts');
    }
};

