<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('buyer_uploads')) {
            return; // safety: table not created yet
        }

        Schema::table('buyer_uploads', function (Blueprint $table) {
            // groups (required → RESTRICT on delete)
            if (Schema::hasTable('groups')) {
                $table->foreign('group_id', 'buyer_uploads_group_fk')
                      ->references('id')->on('groups')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');
            }

            // users (created_by required → RESTRICT; updated_by nullable → SET NULL)
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'buyer_uploads_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');

                $table->foreign('updated_by', 'buyer_uploads_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('buyer_uploads')) return;

        Schema::table('buyer_uploads', function (Blueprint $table) {
            foreach (['buyer_uploads_group_fk','buyer_uploads_created_by_fk','buyer_uploads_updated_by_fk'] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};
