<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('buyer_uploads', function (Blueprint $table) {
            // Consistent engine/collation
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            $table->string('name', 191);
            $table->string('phone', 191)->nullable();
            $table->string('email', 191)->nullable();
            $table->string('contact_person', 191)->nullable();
            $table->text('overseas_agent')->nullable();
            $table->string('brand', 191)->nullable();
            $table->text('address')->nullable();

            // Keep as simple int(11) to mirror your dump (no FK)
            $table->integer('country_id')->nullable();
            $table->integer('currency_id')->nullable();

            // FK columns (constraints added in next migration)
            $table->unsignedBigInteger('group_id');        // NOT NULL
            $table->unsignedBigInteger('created_by');      // NOT NULL
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();

            $table->tinyInteger('buyer_type')->default(1);

            // Index names matching your dump
            $table->index('group_id',   'buyer_uploads_group_id_foreign');
            $table->index('created_by', 'buyer_uploads_created_by_foreign');
            $table->index('updated_by', 'buyer_uploads_updated_by_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('buyer_uploads');
    }
};
