<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('buyers')) {
            return; // safety guard
        }

        Schema::table('buyers', function (Blueprint $table) {
            // groups (required → RESTRICT on delete)
            if (Schema::hasTable('groups')) {
                $table->foreign('group_id', 'buyers_group_fk')
                      ->references('id')->on('groups')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');
            }

            // users (created_by required → RESTRICT; updated_by nullable → SET NULL)
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'buyers_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');

                $table->foreign('updated_by', 'buyers_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }

            // Note: country_id / currency_id kept as plain ints per dump (no FK).
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('buyers')) return;

        Schema::table('buyers', function (Blueprint $table) {
            foreach (['buyers_group_fk','buyers_created_by_fk','buyers_updated_by_fk'] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};
