<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('buyers', function (Blueprint $table) {
            // Consistency
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            $table->string('name', 191);
            $table->string('contact_person', 191)->nullable();
            $table->string('image', 191)->nullable()->default('default.png');

            // As per dump: simple int(11), leaving as nullable integers (no FK here)
            $table->integer('country_id')->nullable();
            $table->integer('currency_id')->nullable();

            $table->string('email', 191)->nullable();
            $table->string('phone', 191)->nullable();
            $table->text('overseas_agent')->nullable();
            $table->string('brand', 191)->nullable();
            $table->text('address')->nullable();

            // FK columns (constraints added in next migration)
            $table->unsignedBigInteger('group_id');        // NOT NULL
            $table->unsignedBigInteger('created_by');      // NOT NULL
            $table->unsignedBigInteger('updated_by')->nullable();

            $table->timestamps();

            $table->tinyInteger('buyer_type')->default(1); // NOT NULL DEFAULT 1

            // Index names matching your dump
            $table->index('group_id',   'buyers_group_id_foreign');
            $table->index('created_by', 'buyers_created_by_foreign');
            $table->index('updated_by', 'buyers_updated_by_foreign');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('buyers');
    }
};
