<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        if (!Schema::hasTable('basic_rate_setups')) {
            return; // safety: table not created yet
        }

        // Detect department table name (adjust list if your project differs)
        $departmentTable = null;
        foreach (['departments', 'hr_departments', 'acc_departments'] as $cand) {
            if (Schema::hasTable($cand)) { $departmentTable = $cand; break; }
        }

        Schema::table('basic_rate_setups', function (Blueprint $table) use ($departmentTable) {
            // companies (NOT NULL → RESTRICT)
            if (Schema::hasTable('companies')) {
                $table->foreign('company_id', 'brs_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');
            }

            // departments (NOT NULL → RESTRICT)
            if ($departmentTable) {
                $table->foreign('department_id', 'brs_department_fk')
                      ->references('id')->on($departmentTable)
                      ->onUpdate('cascade')
                      ->onDelete('restrict');
            }

            // users (created_by NOT NULL → RESTRICT, updated_by NULL → SET NULL)
            if (Schema::hasTable('users')) {
                $table->foreign('created_by', 'brs_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');

                $table->foreign('updated_by', 'brs_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('basic_rate_setups')) return;

        Schema::table('basic_rate_setups', function (Blueprint $table) {
            // Guarded drops (ignore if not present)
            foreach (['brs_company_fk','brs_department_fk','brs_created_by_fk','brs_updated_by_fk'] as $fk) {
                try { $table->dropForeign($fk); } catch (\Throwable $e) {}
            }
        });
    }
};
