<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('basic_rate_setups', function (Blueprint $table) {
            // Consistency
            $table->engine    = 'InnoDB';
            $table->charset   = 'utf8mb4';
            $table->collation = 'utf8mb4_unicode_ci';

            $table->id(); // BIGINT UNSIGNED AI

            $table->decimal('rate', 15, 2);           // NOT NULL
            $table->unsignedBigInteger('company_id'); // NOT NULL
            $table->unsignedBigInteger('department_id'); // NOT NULL
            $table->string('effected_month', 191);    // NOT NULL (dump shows varchar)

            // Audit
            $table->unsignedBigInteger('created_by');       // NOT NULL
            $table->unsignedBigInteger('updated_by')->nullable(); // NULL

            $table->timestamps(); // created_at, updated_at (nullable)

            // Indexes exactly as in your dump
            $table->index('created_by', 'basic_rate_setups_created_by_foreign');
            $table->index('updated_by', 'basic_rate_setups_updated_by_foreign');

            // (Optional) If you want faster lookups by company/department uncomment:
            // $table->index('company_id', 'brs_company_idx');
            // $table->index('department_id', 'brs_dept_idx');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('basic_rate_setups');
    }
};

