<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('banks', function (Blueprint $table) {
            if (Schema::hasTable('companies')) {
                // company_id: NOT NULL -> RESTRICT on delete, CASCADE on update
                $table->foreign('company_id', 'banks_company_fk')
                      ->references('id')->on('companies')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');
            }

            if (Schema::hasTable('users')) {
                // created_by: NOT NULL -> RESTRICT on delete
                $table->foreign('created_by', 'banks_created_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('restrict');

                // updated_by: NULLABLE -> SET NULL on delete
                $table->foreign('updated_by', 'banks_updated_by_fk')
                      ->references('id')->on('users')
                      ->onUpdate('cascade')
                      ->onDelete('set null');
            }
        });
    }

    public function down(): void
    {
        Schema::table('banks', function (Blueprint $table) {
            // Guarded drops in case some weren’t created
            try { $table->dropForeign('banks_company_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('banks_created_by_fk'); } catch (\Throwable $e) {}
            try { $table->dropForeign('banks_updated_by_fk'); } catch (\Throwable $e) {}
        });
    }
};
